package w83b.w83bOperacionesPaso.w83bHistoricos;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bHistoricosBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bOperacionesPaso.w83bResultados.W83bTablaCuadroResultadosExcelAction;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bUtilidades;
import w83b.w83bUtilidadesComunes.W83bUtilidadesN38API;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

public class W83bCrearDelegConvenioHistAction extends Q70ActionPasoOP{
	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
	}
	

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);

		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bHistDelegConvenio.xls";
		InputStream inputStream = W83bTablaCuadroResultadosExcelAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream);
		
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja
        
        List losDatos = (ArrayList)contexto.get("w83bResultadoHistorico");
        List sectores = (ArrayList)losDatos.get(losDatos.size()-3);
        HashMap sumas = (HashMap)losDatos.get(losDatos.size()-2);
        List total = (ArrayList)losDatos.get(losDatos.size()-1);
        
        HSSFCellStyle normalTexto = this.normalTexto(wb);
        HSSFCellStyle normalCentrado = this.normalCentrado(wb);
        HSSFCellStyle normalNumero = this.normalNumero(wb);
        HSSFCellStyle normalLetra = this.normalLetra(wb);
        HSSFCellStyle sinBordeAbajo = this.sinBordeAbajo(wb);
        HSSFCellStyle normalCentradoSinBordes = this.normalCentradoSinBordes(wb);
        W83bUtilidadesExcel excel = new W83bUtilidadesExcel(wb);
        W83bHistoricosBean losCriterios = (W83bHistoricosBean)losDatos.get(0); 
        
       	String territorio = "";
        if (losCriterios.getTerritorio()== null || "".equals(losCriterios.getTerritorio()) || "null".equals(losCriterios.getTerritorio())){
        	territorio = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.comautvascaentero",idioma);
        }
        else{
        	territorio = losCriterios.getDescTerritorio().toUpperCase();
        }
               
        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO));      
        
        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
        String provincia = W83bUtilidadesN38API.elegirProvinciaDelegacion(usuario.getPerfilXLNets());       
         
        StringBuffer tituloImagenEu = new StringBuffer();
        StringBuffer tituloImagenEs = new StringBuffer();
        
        tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme_eu",idioma));
        tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme_es",idioma));
        
        HSSFRow laRoww = sheet.getRow((short)4); 
        HSSFCell cell = laRoww.getCell((short)7);
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = laRoww.getCell((short)10); 
        cell.setCellValue(tituloImagenEs.toString());
        
        tituloImagenEu = new StringBuffer();
        tituloImagenEs = new StringBuffer();
        
        
        if(W83bClsConstantes.CONSTANTE_SERVICIOS_CENTRALES.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_es",idioma));
        }
        else if(W83bClsConstantes.CONSTANTE_ALAVA.equals(provincia)){
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_es",idioma));
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_eu",idioma));
        }
        else if(W83bClsConstantes.CONSTANTE_GIPUZKOA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_es",idioma));
        }
        else if(W83bClsConstantes.CONSTANTE_BIZKAIA.equals(provincia)){
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_es",idioma));
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_eu",idioma));        	
        }
        
                
        laRoww = sheet.getRow((short)6); 
        cell = laRoww.getCell((short)7);
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = laRoww.getCell((short)10); 
        cell.setCellValue(tituloImagenEs.toString());
        
        W83bHistoricosBean elDato = new W83bHistoricosBean();
        
        laRoww = sheet.getRow((short)9); 
        cell = laRoww.getCell((short)0);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.historicos.delegConvenioHist").toUpperCase());
        
        String territorioAnterior=""; 
        String sectorAnterior=""; 
        String convenioAnterior=""; 
        int fila =8;
        int filaSumar=0;
        int totalDelegados=0;
        int primeraFilaSector=0;
        int ultimaFilaSector=0;
        int centrosTotal=0;
		int trabajadoresTotal=0;
		int electoresTotal=0;
		int votantesTotal=0;
		int delTotal=0;
               
        for (int i=0;i<(losDatos.size()-3);i++){
        	 elDato = (W83bHistoricosBean)losDatos.get(i);
        	 
        	 if(!territorioAnterior.equals(elDato.getDescTerritorio()) || !sectorAnterior.equals(elDato.getSector())){
        		 if(i!=0){
        			 fila++;
        			 int filaActual=fila;
        			 W83bHistoricosBean elDatoAnterior = (W83bHistoricosBean)losDatos.get(i-1);
        			         			 
        			 laRoww = sheet.createRow((short)fila);
        			
        			 cell = laRoww.createCell((short)2);
            	     cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.resultados.totalsector").toUpperCase());
            	     cell.setCellStyle(sinBordeAbajo);
        			 cell = laRoww.createCell((short)7);
    	    	     cell.setCellFormula("SUM(H"+(primeraFilaSector+1)+":H"+(ultimaFilaSector+1)+")");
    	    	     cell.setCellStyle(normalNumero);
    	    	     cell = laRoww.createCell((short)8);
    	    	     cell.setCellFormula("SUM(I"+(primeraFilaSector+1)+":I"+(ultimaFilaSector+1)+")");
    	    	     cell.setCellStyle(normalNumero);
    	    	     cell = laRoww.createCell((short)9);
    	    	     cell.setCellFormula("SUM(J"+(primeraFilaSector+1)+":J"+(ultimaFilaSector+1)+")");
    	    	     cell.setCellStyle(normalNumero);
    	    	     cell = laRoww.createCell((short)10);
    	    	     cell.setCellFormula("SUM(K"+(primeraFilaSector+1)+":K"+(ultimaFilaSector+1)+")");
    	    	     cell.setCellStyle(normalNumero); 
    	    	     cell = laRoww.createCell((short)11);
    	    	     cell.setCellFormula("SUM(L"+(primeraFilaSector+1)+":L"+(ultimaFilaSector+1)+")");
    	    	     cell.setCellStyle(normalNumero); 
    	    	     cell = laRoww.createCell((short)12);
    	    	     cell.setCellFormula("(K"+(fila+1)+")/J"+(ultimaFilaSector+3)+")");
    	    	     cell.setCellStyle(this.stylePorcentajesDcha(excel));
    	    	     W83bHistoricosBean elSector = new W83bHistoricosBean();//NOPMD
    	    	     for (int j=0;j<sectores.size();j++){
    	    	    	 elSector = (W83bHistoricosBean)sectores.get(j);
    	    	    	 if(elSector.getSector().equals(elDatoAnterior.getSector())){
    	    	    		 laRoww = sheet.createRow((short)fila);
    	    	    		 cell = laRoww.createCell((short)13);
    	    	    	     cell.setCellValue(this.numero(elSector.getSindicato80()));
    	    	    	     cell.setCellStyle(normalNumero);
    	    	    	     cell = laRoww.createCell((short)14);
    	    	    	     cell.setCellValue(elSector.getSiglas());
    	    	    	     cell.setCellStyle(normalLetra);
    	    	    	     cell = laRoww.createCell((short)15);
    	    	    	     cell.setCellValue(this.numero(elSector.getTotDel()));
    	    	    	     //totalDelegados=totalDelegados+this.numero(elDato.getTotDel());
    	    	    	     cell.setCellStyle(normalNumero);
    	    	    	     cell = laRoww.createCell((short)16);
    	    	    	     cell.setCellFormula("(P"+(fila+1)+")/L"+(filaActual+1));
    	    	    	     cell.setCellStyle(this.stylePorcentajesDcha(excel));
    	    	    	     fila++;
    	    	    	 }
    	    	     }
    	    	     
    	    	     if(fila<50){
    	    				 fila = 50;
	    			 }else{
	    				int div = ((fila-51)/41)+1;
	    	     	    fila = 50+(41*(div)); 
	    			 }
    	    	          	    	   
        		 }
        		 
        		 
        		 fila=fila+3;
        		 
        		 laRoww = sheet.createRow((short)fila); 
        		 sheet.addMergedRegion(new Region((short)fila,Short.parseShort("3"),(short)fila,Short.parseShort("4")));//NOPMD
        	     cell = laRoww.createCell((short)3);
        	     cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.centroTrabajo.t").toUpperCase());
        	     cell.setCellStyle(sinBordeAbajo);
        	     cell = laRoww.createCell((short)4);
        	     cell.setCellStyle(sinBordeAbajo);
        	     cell = laRoww.createCell((short)5);
        	     cell.setCellValue(territorio);
        	     cell.setCellStyle(sinBordeAbajo);
        	     fila++;
        	     laRoww = sheet.createRow((short)fila); 
        	     sheet.addMergedRegion(new Region((short)fila,Short.parseShort("3"),(short)fila,Short.parseShort("4")));//NOPMD
        	     cell = laRoww.createCell((short)3);
        	     cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.centroTrabajo.sector").toUpperCase());
        	     cell.setCellStyle(sinBordeAbajo);
        	     cell = laRoww.createCell((short)4);
        	     cell.setCellStyle(sinBordeAbajo);
        	     cell = laRoww.createCell((short)5);
        	     cell.setCellValue(elDato.getSectorTxt());
        	     cell.setCellStyle(sinBordeAbajo);
        	     
        	     fila=fila+2;
        	     laRoww = sheet.createRow((short)fila);
        	     laRoww.setHeightInPoints((short)25);
        	     cell = laRoww.createCell((short)13);
        	     cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.certificaciones.centralSindical").toUpperCase());
        	     sheet.addMergedRegion(new Region(fila,Short.parseShort("13"),fila,Short.parseShort("14")));//NOPMD
        	     cell.setCellStyle(normalCentradoSinBordes);
        	     cell = laRoww.createCell((short)15);
        	     cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.menu.Delegados").toUpperCase());
        	     sheet.addMergedRegion(new Region(fila,Short.parseShort("15"),fila,Short.parseShort("16")));//NOPMD
        	     cell.setCellStyle(normalCentradoSinBordes);
        	     
        	     fila++;
        	     laRoww = sheet.createRow((short)fila); 
        	     laRoww.setHeightInPoints((short)25);
        	     cell = laRoww.createCell((short)2);
        	     cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.resultados.denominacionconvenio").toUpperCase());
        	     cell.setCellStyle(normalTexto);
        	     cell = laRoww.createCell((short)3);
        	     cell.setCellStyle(normalTexto);
        	     cell = laRoww.createCell((short)4);
        	     cell.setCellStyle(normalTexto);
        	     cell = laRoww.createCell((short)5);
        	     cell.setCellStyle(normalTexto);
        	     cell = laRoww.createCell((short)6);
        	     cell.setCellStyle(normalTexto);
        	     sheet.addMergedRegion(new Region(fila,Short.parseShort("2"),fila,Short.parseShort("6")));//NOPMD
        	     cell.setCellStyle(normalTexto);
        	     cell = laRoww.createCell((short)7);
        	     cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.comunicaciones.centros").toUpperCase());
        	     cell.setCellStyle(normalCentrado);
        	     cell = laRoww.createCell((short)8);
        	     cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.historicos.trabaj").toUpperCase());
        	     cell.setCellStyle(normalCentrado);
        	     cell = laRoww.createCell((short)9);
        	     cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.elect").toUpperCase());
        	     cell.setCellStyle(normalCentrado);
        	     cell = laRoww.createCell((short)10);
        	     cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.historicos.votant").toUpperCase());
        	     cell.setCellStyle(normalCentrado);
        	     cell = laRoww.createCell((short)11);
        	     cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.deleg").toUpperCase());
        	     cell.setCellStyle(normalCentrado);
        	     cell = laRoww.createCell((short)12);
        	     cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.historicos.partic").toUpperCase());
        	     cell.setCellStyle(normalCentrado);
        	     cell = laRoww.createCell((short)13);
        	     cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.resultados.cod").toUpperCase());
        	     cell.setCellStyle(normalCentrado);
        	     cell = laRoww.createCell((short)14);
        	     cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.sindicatos.siglas").toUpperCase());
        	     cell.setCellStyle(normalCentrado);
        	     cell = laRoww.createCell((short)15);
        	     cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.resultados.num").toUpperCase());
        	     cell.setCellStyle(normalCentrado);
        	     cell = laRoww.createCell((short)16);
        	     cell.setCellValue("%");
        	     cell.setCellStyle(normalCentrado);
        	     fila++;
        	     primeraFilaSector=fila;
        	 }
        	 laRoww = sheet.createRow((short)fila); 
        	
        	 if(!convenioAnterior.equals(elDato.getConvenio80())){
        		        		 
	    	     cell = laRoww.createCell((short)2);
	    	     cell.setCellValue(elDato.getConvenioTxt());
	    	     sheet.addMergedRegion(new Region(fila,Short.parseShort("2"),fila,Short.parseShort("6")));//NOPMD
	    	     cell.setCellStyle(normalLetra);
	    	     if(elDato.getConvenioTxt().length()>35){
	    	    	 laRoww.setHeightInPoints((short)(25*((elDato.getConvenioTxt().length())/35)+1));
	    	    	 
	    	     }
	    	     
	    	     centrosTotal = centrosTotal+Integer.parseInt(elDato.getTotCentros());
    			 trabajadoresTotal = trabajadoresTotal+Integer.parseInt(elDato.getTotTrabajadores());
    			 electoresTotal=electoresTotal+Integer.parseInt(elDato.getTotElectores());
    			 votantesTotal=votantesTotal+Integer.parseInt(elDato.getTotVotantes());
    			 
    			 
	    	     cell = laRoww.createCell((short)7);
	    	     cell.setCellValue(this.numero(elDato.getTotCentros()));
	    	     cell.setCellStyle(normalNumero);
	    	     cell = laRoww.createCell((short)8);
	    	     cell.setCellValue(this.numero(elDato.getTotTrabajadores()));
	    	     cell.setCellStyle(normalNumero);
	    	     cell = laRoww.createCell((short)9);
	    	     cell.setCellValue(this.numero(elDato.getTotElectores()));
	    	     cell.setCellStyle(normalNumero);
	    	     cell = laRoww.createCell((short)10);
	    	     cell.setCellValue(this.numero(elDato.getTotVotantes()));
	    	     
	    	     cell.setCellStyle(normalNumero);
	    	     cell = laRoww.createCell((short)11);
	    	     
	    	     cell.setCellValue(W83bUtilidades.numero((String)sumas.get(elDato.getSector()+elDato.getConvenio80())));
        			    	  
	    	     cell.setCellStyle(normalNumero);
	    	     cell = laRoww.createCell((short)12);
	    	     cell.setCellValue(this.calcularPorcentaje(elDato.getTotVotantes(), elDato.getTotElectores()));
	    	     cell.setCellStyle(this.stylePorcentajesDcha(excel));
	    	     
	    	     filaSumar=fila;
	    	     
	    	    
        	 }
    	     cell = laRoww.createCell((short)13);
    	     cell.setCellValue(this.numero(elDato.getSindicato80()));
    	     cell.setCellStyle(normalNumero);
    	     cell = laRoww.createCell((short)14);
    	     cell.setCellValue(elDato.getSiglas());
    	     cell.setCellStyle(normalLetra);
    	     cell = laRoww.createCell((short)15);
    	     cell.setCellValue(this.numero(elDato.getTotDel()));
    	     totalDelegados=totalDelegados+this.numero(elDato.getTotDel());
    	     delTotal=delTotal+Integer.parseInt(elDato.getTotDel());
    	     cell.setCellStyle(normalNumero);
    	     cell = laRoww.createCell((short)16);
    	     cell.setCellFormula("(P"+(fila+1)+")/L"+(filaSumar+1));
    	     cell.setCellStyle(this.stylePorcentajesDcha(excel));
    	     
    	     ultimaFilaSector=fila;
    	         	    
    	     fila++;
    	     
    	     territorioAnterior=elDato.getDescTerritorio();
    		 sectorAnterior=elDato.getSector();
    		 convenioAnterior=elDato.getConvenio80();
    		 
        }
        
        HSSFRow laRoww2 = sheet.getRow((short)filaSumar); 
		 cell = laRoww2.createCell((short)11);
		 cell.setCellValue(W83bUtilidades.numero((String)sumas.get(elDato.getSector()+elDato.getConvenio80())));
		 totalDelegados=0;
	     cell.setCellStyle(normalNumero);
	     
	     fila++;
	     int filaActual = fila;
		 laRoww = sheet.createRow((short)fila);
		 
		 cell = laRoww.createCell((short)2);
	     cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.resultados.totalsector").toUpperCase());
	     cell.setCellStyle(sinBordeAbajo);
	     
		 cell = laRoww.createCell((short)7);
	     cell.setCellFormula("SUM(H"+(primeraFilaSector+1)+":H"+(ultimaFilaSector+1)+")");
	     cell.setCellStyle(normalNumero);
	    
	     cell = laRoww.createCell((short)8);
	     cell.setCellFormula("SUM(I"+(primeraFilaSector+1)+":I"+(ultimaFilaSector+1)+")");
	     cell.setCellStyle(normalNumero);
	     
	     cell = laRoww.createCell((short)9);
	     cell.setCellFormula("SUM(J"+(primeraFilaSector+1)+":J"+(ultimaFilaSector+1)+")");
	     cell.setCellStyle(normalNumero);
	     
	     cell = laRoww.createCell((short)10);
	     cell.setCellFormula("SUM(K"+(primeraFilaSector+1)+":K"+(ultimaFilaSector+1)+")");
	     cell.setCellStyle(normalNumero); 
	     
	     cell = laRoww.createCell((short)11);
	     cell.setCellFormula("SUM(L"+(primeraFilaSector+1)+":L"+(ultimaFilaSector+1)+")");
	     cell.setCellStyle(normalNumero); 
	     
	     cell = laRoww.createCell((short)12);
	     cell.setCellFormula("(K"+(fila+1)+")/J"+(ultimaFilaSector+3)+")");
	     cell.setCellStyle(this.stylePorcentajesDcha(excel));
	     
	     W83bHistoricosBean elSector = new W83bHistoricosBean();//NOPMD
	     for (int j=0;j<sectores.size();j++){
	    	 elSector = (W83bHistoricosBean)sectores.get(j);
	    	 if(elSector.getSector().equals(elDato.getSector())){
	    		 laRoww = sheet.createRow((short)fila);
	    		 cell = laRoww.createCell((short)13);
	    	     cell.setCellValue(this.numero(elSector.getSindicato80()));
	    	     cell.setCellStyle(normalNumero);
	    	     cell = laRoww.createCell((short)14);
	    	     cell.setCellValue(elSector.getSiglas());
	    	     cell.setCellStyle(normalLetra);
	    	     cell = laRoww.createCell((short)15);
	    	     cell.setCellValue(this.numero(elSector.getTotDel()));	    	  
	    	     cell.setCellStyle(normalNumero);
	    	     cell = laRoww.createCell((short)16);
	    	     cell.setCellFormula("(P"+(fila+1)+")/L"+(filaActual+1));
	    	     cell.setCellStyle(this.stylePorcentajesDcha(excel));
	    	     
	    	     fila++;
	    	 }
	     }
	     
	     fila=fila+3;
	     
		 int filaTotal = fila;
		 
		 W83bHistoricosBean elTotal = new W83bHistoricosBean();//NOPMD
		     for (int j=0;j<total.size();j++){
		    	 elTotal = (W83bHistoricosBean)total.get(j);
		    	 
		    	 HSSFRow laRoww3 = sheet.createRow((short)filaTotal); 
		    	 cell = laRoww3.createCell((short)13);
		    	 cell.setCellValue(this.numero(elTotal.getSindicato80()));
	    	     cell.setCellStyle(normalNumero);
	    	     cell = laRoww3.createCell((short)14);
	    	     cell.setCellValue(elTotal.getSiglas());
	    	     cell.setCellStyle(normalLetra);
	    	     cell = laRoww3.createCell((short)15);
	    	     cell.setCellValue(this.numero(elTotal.getTotDel()));
	    	     cell = laRoww3.createCell((short)16);
	    	     cell.setCellFormula("(P"+(filaTotal+1)+")/L"+(fila+1));
	    	     cell.setCellStyle(this.stylePorcentajesDcha(excel));
	    	     
	    	     filaTotal++;
		    	 
		     }
		 
	     laRoww2 = sheet.getRow((short)fila); 
		 cell = laRoww2.createCell((short)2);
		 cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.centroTrabajo.totalTerritorio").toUpperCase());
		 cell.setCellStyle(sinBordeAbajo);
		 		 
		 cell = laRoww2.createCell((short)7);
 	     cell.setCellValue(centrosTotal);
 	     cell.setCellStyle(normalNumero);
 	     cell = laRoww2.createCell((short)8);
 	     cell.setCellValue(trabajadoresTotal);
 	     cell.setCellStyle(normalNumero);
 	     cell = laRoww2.createCell((short)9);
 	     cell.setCellValue(electoresTotal);
 	     cell.setCellStyle(normalNumero);
 	     cell = laRoww2.createCell((short)10);
	     cell.setCellValue(votantesTotal);
	     cell.setCellStyle(normalNumero);	     
	     cell = laRoww2.createCell((short)11);
	     cell.setCellValue(delTotal);
	     cell.setCellStyle(normalNumero);
	     cell = laRoww2.createCell((short)12);
	     cell.setCellValue(this.calcularPorcentaje((votantesTotal+""), (electoresTotal+"")));
	     cell.setCellStyle(this.stylePorcentajesDcha(excel));
	     
       
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        String nombreFichero = "listadoDelegConvenioHistorico.xls";
        response.setHeader("Content-Disposition","attachment; filename=" +nombreFichero);
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();
        
		return null;
	}
	
	private HSSFCellStyle stylePorcentajesDcha(W83bUtilidadesExcel excel){
		return excel.stylePorcentajesDcha;	
	}
	
	private HSSFCellStyle sinBordeAbajo(HSSFWorkbook wb){
		HSSFCellStyle sinBordeAbajo =  wb.createCellStyle();
		
		sinBordeAbajo = wb.createCellStyle();// Estilo		
		sinBordeAbajo.setAlignment(HSSFCellStyle.ALIGN_LEFT);		
		sinBordeAbajo.setFont(this.negrita(wb));
		return sinBordeAbajo;
		
	}
	
	private HSSFCellStyle normalNumero(HSSFWorkbook wb){
		HSSFCellStyle normalNumero =  wb.createCellStyle();
		
		normalNumero = wb.createCellStyle();// Estilo		
		normalNumero.setAlignment(HSSFCellStyle.ALIGN_RIGHT);	
		normalNumero.setDataFormat((short)3);
		return normalNumero;
		
	}
	
	private HSSFCellStyle normalCentrado(HSSFWorkbook wb){
		HSSFCellStyle normal =  wb.createCellStyle();		
		normal = wb.createCellStyle();// Estilo
		normal.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);
		normal.setBorderBottom(HSSFCellStyle.BORDER_THIN);
		normal.setAlignment(HSSFCellStyle.ALIGN_JUSTIFY);
		normal.setFont(this.negrita(wb));
		return normal;
		
	}

	private HSSFCellStyle normalLetra(HSSFWorkbook wb){
		HSSFCellStyle normalLetra =  wb.createCellStyle();
		normalLetra = wb.createCellStyle();// Estilo		
		normalLetra.setAlignment(HSSFCellStyle.ALIGN_LEFT);		
		normalLetra.setAlignment(HSSFCellStyle.ALIGN_JUSTIFY);
		normalLetra.setWrapText(true);
		return normalLetra;
		
	}
	
	private HSSFCellStyle normalCentradoSinBordes(HSSFWorkbook wb){
		HSSFCellStyle normal =  wb.createCellStyle();		
		normal = wb.createCellStyle();// Estilo
		normal.setAlignment(HSSFCellStyle.ALIGN_JUSTIFY);	
		normal.setFont(this.negrita(wb));
		return normal;
		
	}

	private HSSFCellStyle normalTexto(HSSFWorkbook wb){
		HSSFCellStyle normalTexto =  wb.createCellStyle();
		
		normalTexto = wb.createCellStyle();// Estilo
		normalTexto.setFont(this.negrita(wb));
		normalTexto.setAlignment(HSSFCellStyle.ALIGN_JUSTIFY);	
		normalTexto.setBorderBottom(HSSFCellStyle.BORDER_THIN);
		
		return normalTexto;
		
	}	
	
	private HSSFFont negrita (HSSFWorkbook wb){
		
		HSSFFont fuente = wb.createFont();
		fuente.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
		
		return fuente;
		
	}	
		
	
	private float calcularPorcentaje(String totalParcial,String total){
		
		Integer parcial=new Integer(totalParcial);
		Integer totalT=new Integer(total);

		
		if (totalT.intValue()==0){
			return 0;
		}
		else{
			return((float)parcial.intValue())/(float)totalT.intValue();			
		}
	}
	
	private int numero(String num){		
		Integer n = new Integer(num);
		return n.intValue();
	}
	
}